<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\SchoolInfoModel;

class Informasi extends BaseController
{
    protected $schoolInfo;

    public function __construct()
    {
        $this->schoolInfo = new SchoolInfoModel();
    }

    private function getRow()
    {
        // kita pakai 1 baris saja (id=1). kalau belum ada, buat dulu.
        $row = $this->schoolInfo->find(1);
        if (!$row) {
            $this->schoolInfo->insert(['id' => 1]);
            $row = $this->schoolInfo->find(1);
        }
        return $row;
    }

    public function index()
    {
        return view('admin/informasi/index', [
            'title' => 'Informasi Sekolah',
            'row'   => $this->getRow(),
        ]);
    }

    
    public function branding()
    {
        return view('admin/informasi/branding', [
            'title' => 'Branding Sekolah',
            'row'   => $this->getRow(), // ini pasti array + pasti ada id=1
        ]);
    }

    public function updateBranding()
{
    $data = [
        'school_name' => $this->request->getPost('school_name'),
        'tagline'     => $this->request->getPost('tagline'), // <-- tagline masuk
        'updated_at'  => date('Y-m-d H:i:s'),
    ];

    // upload logo
    $logo = $this->request->getFile('logo');
    if ($logo && $logo->isValid() && !$logo->hasMoved()) {
        $newName = $logo->getRandomName();
        $logo->move(FCPATH . 'uploads/branding', $newName);
        $data['logo_path'] = 'uploads/branding/' . $newName;
    }

    // upload hero bg
    $hero = $this->request->getFile('hero_bg');
    if ($hero && $hero->isValid() && !$hero->hasMoved()) {
        $newName = $hero->getRandomName();
        $hero->move(FCPATH . 'uploads/branding', $newName);
        $data['hero_bg_path'] = 'uploads/branding/' . $newName;
    }

    // simpan
    $this->schoolInfo->update(1, $data);

    // INI BIAR BALIK KE HALAMAN YANG NGIRIM (dashboard atau halaman branding)
    $redirectTo = $this->request->getPost('redirect_to') ?: site_url('admin');
    return redirect()->to($redirectTo)->with('success', 'Branding berhasil diperbarui.');
}  
    
    public function updateSosmed()
    {
        $this->schoolInfo->update(1, [
            'facebook_url'  => $this->request->getPost('facebook_url'),
            'instagram_url' => $this->request->getPost('instagram_url'),
            'youtube_url'   => $this->request->getPost('youtube_url'),
            'email'         => $this->request->getPost('email'),
            'updated_at'    => date('Y-m-d H:i:s'),
        ]);

        return redirect()->to(site_url('admin/informasi'))->with('success', 'Sosial media berhasil diperbarui.');
    }

    public function visiMisi()
    {
        return view('admin/informasi/visimisi', [
            'title' => 'Visi, Misi & Tujuan',
            'schoolInfo'   => $this->schoolInfo->find(1),
        ]);
    }   
    
    public function updateVisiMisi()
    {
        $this->schoolInfo->update(1, [
            'visi'       => $this->request->getPost('visi'),
            'misi'       => $this->request->getPost('misi'),
            'tujuan'     => $this->request->getPost('tujuan'),
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    
        return redirect()->to(site_url('admin/visi-misi'))
            ->with('success', 'Visi, Misi & Tujuan berhasil diperbarui.');
    }

    public function kepsek()
    {
        return view('admin/informasi/kepsek', [
            'title' => 'Informasi Sekolah',
            'row'   => $this->getRow(),
        ]);
    }  
public function updateKepsek()
{
    $data = [
        'kepsek_nama'     => $this->request->getPost('kepsek_nama'),
        'kepsek_sambutan' => $this->request->getPost('kepsek_sambutan'),
        'kepsek_judul_highlight' => $this->request->getPost('kepsek_judul_highlight'),
        'updated_at'      => date('Y-m-d H:i:s'),
    ];

    $file = $this->request->getFile('kepsek_foto');
    if ($file && $file->isValid() && !$file->hasMoved()) {
        $newName = $file->getRandomName();
        $file->move(FCPATH . 'uploads/kepsek', $newName);
        $data['kepsek_foto'] = 'uploads/kepsek/' . $newName;
    }

    $this->schoolInfo->update(1, $data);

    return redirect()->to(site_url('admin/kepsek'))
        ->with('success', 'Data kepala sekolah berhasil diperbarui.');
}

    public function updateTentang()
    {
        $this->schoolInfo->update(1, [
            'tentang_sekolah' => $this->request->getPost('tentang_sekolah'),
            'updated_at'      => date('Y-m-d H:i:s'),
        ]);

        return redirect()->to(site_url('admin/informasi'))->with('success', 'Tentang sekolah berhasil diperbarui.');
    }

public function videoProfile()
{
    return view('admin/informasi/videoprofile', [
        'title' => 'Video Profil Sekolah',
        'row'   => $this->getRow(),
    ]);
}
public function updateVideoProfile()
{
    $this->schoolInfo->update(1, [
        'video_title'       => $this->request->getPost('video_title'),
        'video_description' => $this->request->getPost('video_description'),
        'video_embed'       => $this->request->getPost('video_embed'),
        'updated_at'        => date('Y-m-d H:i:s'),
    ]);

    return redirect()->to(site_url('admin/video-profile'))
        ->with('success', 'Video profil berhasil diperbarui.');
}

public function dataSekolah()
{
    return view('admin/informasi/datasekolah', [
        'title' => 'Data Sekolah',
        'row'   => $this->getRow(),
    ]);
}

public function updateDataSekolah()
{
    $this->schoolInfo->update(1, [
        'stat_guru_angka'   => (int) $this->request->getPost('stat_guru_angka'),
        'stat_guru_label'   => $this->request->getPost('stat_guru_label'),
        'stat_guru_desc'    => $this->request->getPost('stat_guru_desc'),

        'stat_siswa_angka'  => (int) $this->request->getPost('stat_siswa_angka'),
        'stat_siswa_label'  => $this->request->getPost('stat_siswa_label'),
        'stat_siswa_desc'   => $this->request->getPost('stat_siswa_desc'),

        'stat_ekskul_angka' => (int) $this->request->getPost('stat_ekskul_angka'),
        'stat_ekskul_label' => $this->request->getPost('stat_ekskul_label'),
        'stat_ekskul_desc'  => $this->request->getPost('stat_ekskul_desc'),

        'updated_at'        => date('Y-m-d H:i:s'),
    ]);

    return redirect()->to(site_url('admin/data-sekolah'))
        ->with('success', 'Data sekolah berhasil diperbarui.');
}
}